//
//	MBsysTran - Release 8.1
//
//	Copyright 
//	Universite catholique de Louvain (UCLouvain) 
//	Mechatronic, Electrical Energy, and Dynamic systems (MEED Division) 
//	2, Place du Levant
//	1348 Louvain-la-Neuve 
//	Belgium 
//
//	http://www.robotran.be 
//
//	==> Generation Date: Wed Oct  2 16:44:39 2024
//	==> using automatic loading with extension .mbs 
//
//	==> Project name: five_point_suspension_c
//
//	==> Number of joints: 16
//
//	==> Function: F6 - Sensors Kinematics
//
//	==> Git hash: 0cc862d03ff17d3428bf53a85358bd520952fe65
//
//	==> Input XML
//

#include <math.h> 

#include "mbs_data.h"
#include "mbs_sensor.h"

void mbs_gensensor(MbsSensor *sens,
MbsData *s, int isens)
{
#include "mbs_gensensor_five_point_suspension_c.h"

double *q, *qd, *qdd;
double **dpt;

q = s->q;
qd = s->qd;
qdd = s->qdd;

dpt = s->dpt;
 
// Trigonometric functions

S2 = sin(q[2]);
C2 = cos(q[2]);
S3 = sin(q[3]);
C3 = cos(q[3]);
S4 = sin(q[4]);
C4 = cos(q[4]);
S5 = sin(q[5]);
C5 = cos(q[5]);
S6 = sin(q[6]);
C6 = cos(q[6]);
S7 = sin(q[7]);
C7 = cos(q[7]);
S8 = sin(q[8]);
C8 = cos(q[8]);
S9 = sin(q[9]);
C9 = cos(q[9]);
S10 = sin(q[10]);
C10 = cos(q[10]);
S11 = sin(q[11]);
C11 = cos(q[11]);
S12 = sin(q[12]);
C12 = cos(q[12]);
S13 = sin(q[13]);
C13 = cos(q[13]);
S14 = sin(q[14]);
C14 = cos(q[14]);
S15 = sin(q[15]);
C15 = cos(q[15]);
 
// Augmented Joint Position Vectors

 
// Sensor Kinematics


switch(isens)
{
case 1:

sens->P[1] = 0;
sens->P[2] = 0;
sens->P[3] = q[1];
sens->R[1][1] = (1.0);
sens->R[2][2] = (1.0);
sens->R[3][3] = (1.0);
sens->V[1] = 0;
sens->V[2] = 0;
sens->V[3] = qd[1];
sens->OM[1] = 0;
sens->OM[2] = 0;
sens->OM[3] = 0;
sens->J[3][1] = (1.0);
sens->A[1] = 0;
sens->A[2] = 0;
sens->A[3] = qdd[1];
sens->OMP[1] = 0;
sens->OMP[2] = 0;
sens->OMP[3] = 0;

break;

case 2:

POcp2_32 = q[1]+dpt[3][2];
sens->P[1] = dpt[1][2];
sens->P[2] = dpt[2][2];
sens->P[3] = POcp2_32;
sens->R[1][1] = (1.0);
sens->R[2][2] = C2;
sens->R[2][3] = S2;
sens->R[3][2] = -S2;
sens->R[3][3] = C2;
sens->V[1] = 0;
sens->V[2] = 0;
sens->V[3] = qd[1];
sens->OM[1] = qd[2];
sens->OM[2] = 0;
sens->OM[3] = 0;
sens->J[3][1] = (1.0);
sens->J[4][2] = (1.0);
sens->A[1] = 0;
sens->A[2] = 0;
sens->A[3] = qdd[1];
sens->OMP[1] = qdd[2];
sens->OMP[2] = 0;
sens->OMP[3] = 0;

break;

case 3:

ROcp3_23 = C2*S3;
ROcp3_33 = S2*S3;
ROcp3_53 = C2*C3;
ROcp3_63 = S2*C3;
POcp3_32 = q[1]+dpt[3][2];
OMcp3_23 = -qd[3]*S2;
OMcp3_33 = qd[3]*C2;
OPcp3_23 = -qdd[3]*S2-qd[2]*qd[3]*C2;
OPcp3_33 = qdd[3]*C2-qd[2]*qd[3]*S2;
sens->P[1] = dpt[1][2];
sens->P[2] = dpt[2][2];
sens->P[3] = POcp3_32;
sens->R[1][1] = C3;
sens->R[1][2] = ROcp3_23;
sens->R[1][3] = ROcp3_33;
sens->R[2][1] = -S3;
sens->R[2][2] = ROcp3_53;
sens->R[2][3] = ROcp3_63;
sens->R[3][2] = -S2;
sens->R[3][3] = C2;
sens->V[1] = 0;
sens->V[2] = 0;
sens->V[3] = qd[1];
sens->OM[1] = qd[2];
sens->OM[2] = OMcp3_23;
sens->OM[3] = OMcp3_33;
sens->J[3][1] = (1.0);
sens->J[4][2] = (1.0);
sens->J[5][3] = -S2;
sens->J[6][3] = C2;
sens->A[1] = 0;
sens->A[2] = 0;
sens->A[3] = qdd[1];
sens->OMP[1] = qdd[2];
sens->OMP[2] = OPcp3_23;
sens->OMP[3] = OPcp3_33;

break;

case 4:

POcp4_32 = q[1]+dpt[3][3];
sens->P[1] = dpt[1][3];
sens->P[2] = dpt[2][3];
sens->P[3] = POcp4_32;
sens->R[1][1] = (1.0);
sens->R[2][2] = C4;
sens->R[2][3] = S4;
sens->R[3][2] = -S4;
sens->R[3][3] = C4;
sens->V[1] = 0;
sens->V[2] = 0;
sens->V[3] = qd[1];
sens->OM[1] = qd[4];
sens->OM[2] = 0;
sens->OM[3] = 0;
sens->J[3][1] = (1.0);
sens->J[4][4] = (1.0);
sens->A[1] = 0;
sens->A[2] = 0;
sens->A[3] = qdd[1];
sens->OMP[1] = qdd[4];
sens->OMP[2] = 0;
sens->OMP[3] = 0;

break;

case 5:

ROcp5_25 = C4*S5;
ROcp5_35 = S4*S5;
ROcp5_55 = C4*C5;
ROcp5_65 = S4*C5;
POcp5_32 = q[1]+dpt[3][3];
OMcp5_23 = -qd[5]*S4;
OMcp5_33 = qd[5]*C4;
OPcp5_23 = -qdd[5]*S4-qd[4]*qd[5]*C4;
OPcp5_33 = qdd[5]*C4-qd[4]*qd[5]*S4;
sens->P[1] = dpt[1][3];
sens->P[2] = dpt[2][3];
sens->P[3] = POcp5_32;
sens->R[1][1] = C5;
sens->R[1][2] = ROcp5_25;
sens->R[1][3] = ROcp5_35;
sens->R[2][1] = -S5;
sens->R[2][2] = ROcp5_55;
sens->R[2][3] = ROcp5_65;
sens->R[3][2] = -S4;
sens->R[3][3] = C4;
sens->V[1] = 0;
sens->V[2] = 0;
sens->V[3] = qd[1];
sens->OM[1] = qd[4];
sens->OM[2] = OMcp5_23;
sens->OM[3] = OMcp5_33;
sens->J[3][1] = (1.0);
sens->J[4][4] = (1.0);
sens->J[5][5] = -S4;
sens->J[6][5] = C4;
sens->A[1] = 0;
sens->A[2] = 0;
sens->A[3] = qdd[1];
sens->OMP[1] = qdd[4];
sens->OMP[2] = OPcp5_23;
sens->OMP[3] = OPcp5_33;

break;

case 6:

POcp6_32 = q[1]+dpt[3][4];
sens->P[1] = dpt[1][4];
sens->P[2] = dpt[2][4];
sens->P[3] = POcp6_32;
sens->R[1][1] = (1.0);
sens->R[2][2] = C6;
sens->R[2][3] = S6;
sens->R[3][2] = -S6;
sens->R[3][3] = C6;
sens->V[1] = 0;
sens->V[2] = 0;
sens->V[3] = qd[1];
sens->OM[1] = qd[6];
sens->OM[2] = 0;
sens->OM[3] = 0;
sens->J[3][1] = (1.0);
sens->J[4][6] = (1.0);
sens->A[1] = 0;
sens->A[2] = 0;
sens->A[3] = qdd[1];
sens->OMP[1] = qdd[6];
sens->OMP[2] = 0;
sens->OMP[3] = 0;

break;

case 7:

ROcp7_27 = C6*S7;
ROcp7_37 = S6*S7;
ROcp7_57 = C6*C7;
ROcp7_67 = S6*C7;
POcp7_32 = q[1]+dpt[3][4];
OMcp7_23 = -qd[7]*S6;
OMcp7_33 = qd[7]*C6;
OPcp7_23 = -qdd[7]*S6-qd[6]*qd[7]*C6;
OPcp7_33 = qdd[7]*C6-qd[6]*qd[7]*S6;
sens->P[1] = dpt[1][4];
sens->P[2] = dpt[2][4];
sens->P[3] = POcp7_32;
sens->R[1][1] = C7;
sens->R[1][2] = ROcp7_27;
sens->R[1][3] = ROcp7_37;
sens->R[2][1] = -S7;
sens->R[2][2] = ROcp7_57;
sens->R[2][3] = ROcp7_67;
sens->R[3][2] = -S6;
sens->R[3][3] = C6;
sens->V[1] = 0;
sens->V[2] = 0;
sens->V[3] = qd[1];
sens->OM[1] = qd[6];
sens->OM[2] = OMcp7_23;
sens->OM[3] = OMcp7_33;
sens->J[3][1] = (1.0);
sens->J[4][6] = (1.0);
sens->J[5][7] = -S6;
sens->J[6][7] = C6;
sens->A[1] = 0;
sens->A[2] = 0;
sens->A[3] = qdd[1];
sens->OMP[1] = qdd[6];
sens->OMP[2] = OPcp7_23;
sens->OMP[3] = OPcp7_33;

break;

case 8:

POcp8_32 = q[1]+dpt[3][5];
sens->P[1] = dpt[1][5];
sens->P[2] = dpt[2][5];
sens->P[3] = POcp8_32;
sens->R[1][1] = (1.0);
sens->R[2][2] = C8;
sens->R[2][3] = S8;
sens->R[3][2] = -S8;
sens->R[3][3] = C8;
sens->V[1] = 0;
sens->V[2] = 0;
sens->V[3] = qd[1];
sens->OM[1] = qd[8];
sens->OM[2] = 0;
sens->OM[3] = 0;
sens->J[3][1] = (1.0);
sens->J[4][8] = (1.0);
sens->A[1] = 0;
sens->A[2] = 0;
sens->A[3] = qdd[1];
sens->OMP[1] = qdd[8];
sens->OMP[2] = 0;
sens->OMP[3] = 0;

break;

case 9:

ROcp9_29 = C8*S9;
ROcp9_39 = S8*S9;
ROcp9_59 = C8*C9;
ROcp9_69 = S8*C9;
POcp9_32 = q[1]+dpt[3][5];
OMcp9_23 = -qd[9]*S8;
OMcp9_33 = qd[9]*C8;
OPcp9_23 = -qdd[9]*S8-qd[8]*qd[9]*C8;
OPcp9_33 = qdd[9]*C8-qd[8]*qd[9]*S8;
sens->P[1] = dpt[1][5];
sens->P[2] = dpt[2][5];
sens->P[3] = POcp9_32;
sens->R[1][1] = C9;
sens->R[1][2] = ROcp9_29;
sens->R[1][3] = ROcp9_39;
sens->R[2][1] = -S9;
sens->R[2][2] = ROcp9_59;
sens->R[2][3] = ROcp9_69;
sens->R[3][2] = -S8;
sens->R[3][3] = C8;
sens->V[1] = 0;
sens->V[2] = 0;
sens->V[3] = qd[1];
sens->OM[1] = qd[8];
sens->OM[2] = OMcp9_23;
sens->OM[3] = OMcp9_33;
sens->J[3][1] = (1.0);
sens->J[4][8] = (1.0);
sens->J[5][9] = -S8;
sens->J[6][9] = C8;
sens->A[1] = 0;
sens->A[2] = 0;
sens->A[3] = qdd[1];
sens->OMP[1] = qdd[8];
sens->OMP[2] = OPcp9_23;
sens->OMP[3] = OPcp9_33;

break;

case 10:

POcp10_32 = q[1]+dpt[3][6];
sens->P[1] = dpt[1][6];
sens->P[2] = dpt[2][6];
sens->P[3] = POcp10_32;
sens->R[1][1] = (1.0);
sens->R[2][2] = C10;
sens->R[2][3] = S10;
sens->R[3][2] = -S10;
sens->R[3][3] = C10;
sens->V[1] = 0;
sens->V[2] = 0;
sens->V[3] = qd[1];
sens->OM[1] = qd[10];
sens->OM[2] = 0;
sens->OM[3] = 0;
sens->J[3][1] = (1.0);
sens->J[4][10] = (1.0);
sens->A[1] = 0;
sens->A[2] = 0;
sens->A[3] = qdd[1];
sens->OMP[1] = qdd[10];
sens->OMP[2] = 0;
sens->OMP[3] = 0;

break;

case 11:

ROcp11_211 = C10*S11;
ROcp11_311 = S10*S11;
ROcp11_511 = C10*C11;
ROcp11_611 = S10*C11;
POcp11_32 = q[1]+dpt[3][6];
OMcp11_23 = -qd[11]*S10;
OMcp11_33 = qd[11]*C10;
OPcp11_23 = -qdd[11]*S10-qd[10]*qd[11]*C10;
OPcp11_33 = qdd[11]*C10-qd[10]*qd[11]*S10;
sens->P[1] = dpt[1][6];
sens->P[2] = dpt[2][6];
sens->P[3] = POcp11_32;
sens->R[1][1] = C11;
sens->R[1][2] = ROcp11_211;
sens->R[1][3] = ROcp11_311;
sens->R[2][1] = -S11;
sens->R[2][2] = ROcp11_511;
sens->R[2][3] = ROcp11_611;
sens->R[3][2] = -S10;
sens->R[3][3] = C10;
sens->V[1] = 0;
sens->V[2] = 0;
sens->V[3] = qd[1];
sens->OM[1] = qd[10];
sens->OM[2] = OMcp11_23;
sens->OM[3] = OMcp11_33;
sens->J[3][1] = (1.0);
sens->J[4][10] = (1.0);
sens->J[5][11] = -S10;
sens->J[6][11] = C10;
sens->A[1] = 0;
sens->A[2] = 0;
sens->A[3] = qdd[1];
sens->OMP[1] = qdd[10];
sens->OMP[2] = OPcp11_23;
sens->OMP[3] = OPcp11_33;

break;

case 12:

ROcp12_211 = C10*S11;
ROcp12_311 = S10*S11;
ROcp12_511 = C10*C11;
ROcp12_611 = S10*C11;
ROcp12_412 = -S11*C12;
ROcp12_512 = ROcp12_511*C12-S10*S12;
ROcp12_612 = ROcp12_611*C12+C10*S12;
ROcp12_712 = S11*S12;
ROcp12_812 = -ROcp12_511*S12-S10*C12;
ROcp12_912 = -ROcp12_611*S12+C10*C12;
POcp12_32 = q[1]+dpt[3][6];
OMcp12_23 = -qd[11]*S10;
OMcp12_33 = qd[11]*C10;
OPcp12_23 = -qdd[11]*S10-qd[10]*qd[11]*C10;
OPcp12_33 = qdd[11]*C10-qd[10]*qd[11]*S10;
RLcp12_14 = -dpt[2][12]*S11;
RLcp12_24 = ROcp12_511*dpt[2][12];
RLcp12_34 = ROcp12_611*dpt[2][12];
POcp12_14 = RLcp12_14+dpt[1][6];
POcp12_24 = RLcp12_24+dpt[2][6];
POcp12_34 = POcp12_32+RLcp12_34;
JTcp12_14_3 = -RLcp12_24*C10-RLcp12_34*S10;
JTcp12_24_3 = RLcp12_14*C10;
JTcp12_34_3 = RLcp12_14*S10;
OMcp12_14 = qd[10]+qd[12]*C11;
OMcp12_24 = OMcp12_23+ROcp12_211*qd[12];
OMcp12_34 = OMcp12_33+ROcp12_311*qd[12];
ORcp12_14 = OMcp12_23*RLcp12_34-OMcp12_33*RLcp12_24;
ORcp12_24 = OMcp12_33*RLcp12_14-RLcp12_34*qd[10];
ORcp12_34 = -OMcp12_23*RLcp12_14+RLcp12_24*qd[10];
VIcp12_34 = ORcp12_34+qd[1];
OPcp12_14 = qdd[10]+qdd[12]*C11+qd[12]*(OMcp12_23*ROcp12_311-OMcp12_33*ROcp12_211);
OPcp12_24 = OPcp12_23+ROcp12_211*qdd[12]+qd[12]*(OMcp12_33*C11-ROcp12_311*qd[10]);
OPcp12_34 = OPcp12_33+ROcp12_311*qdd[12]+qd[12]*(-OMcp12_23*C11+ROcp12_211*qd[10]);
ACcp12_14 = OMcp12_23*ORcp12_34-OMcp12_33*ORcp12_24+OPcp12_23*RLcp12_34-OPcp12_33*RLcp12_24;
ACcp12_24 = OMcp12_33*ORcp12_14+OPcp12_33*RLcp12_14-ORcp12_34*qd[10]-RLcp12_34*qdd[10];
ACcp12_34 = qdd[1]-OMcp12_23*ORcp12_14-OPcp12_23*RLcp12_14+ORcp12_24*qd[10]+RLcp12_24*qdd[10];
sens->P[1] = POcp12_14;
sens->P[2] = POcp12_24;
sens->P[3] = POcp12_34;
sens->R[1][1] = C11;
sens->R[1][2] = ROcp12_211;
sens->R[1][3] = ROcp12_311;
sens->R[2][1] = ROcp12_412;
sens->R[2][2] = ROcp12_512;
sens->R[2][3] = ROcp12_612;
sens->R[3][1] = ROcp12_712;
sens->R[3][2] = ROcp12_812;
sens->R[3][3] = ROcp12_912;
sens->V[1] = ORcp12_14;
sens->V[2] = ORcp12_24;
sens->V[3] = VIcp12_34;
sens->OM[1] = OMcp12_14;
sens->OM[2] = OMcp12_24;
sens->OM[3] = OMcp12_34;
sens->J[1][11] = JTcp12_14_3;
sens->J[2][10] = -RLcp12_34;
sens->J[2][11] = JTcp12_24_3;
sens->J[3][1] = (1.0);
sens->J[3][10] = RLcp12_24;
sens->J[3][11] = JTcp12_34_3;
sens->J[4][10] = (1.0);
sens->J[4][12] = C11;
sens->J[5][11] = -S10;
sens->J[5][12] = ROcp12_211;
sens->J[6][11] = C10;
sens->J[6][12] = ROcp12_311;
sens->A[1] = ACcp12_14;
sens->A[2] = ACcp12_24;
sens->A[3] = ACcp12_34;
sens->OMP[1] = OPcp12_14;
sens->OMP[2] = OPcp12_24;
sens->OMP[3] = OPcp12_34;

break;

case 13:

ROcp13_211 = C10*S11;
ROcp13_311 = S10*S11;
ROcp13_511 = C10*C11;
ROcp13_611 = S10*C11;
ROcp13_412 = -S11*C12;
ROcp13_512 = ROcp13_511*C12-S10*S12;
ROcp13_612 = ROcp13_611*C12+C10*S12;
ROcp13_712 = S11*S12;
ROcp13_812 = -ROcp13_511*S12-S10*C12;
ROcp13_912 = -ROcp13_611*S12+C10*C12;
ROcp13_113 = -ROcp13_712*S13+C11*C13;
ROcp13_213 = ROcp13_211*C13-ROcp13_812*S13;
ROcp13_313 = ROcp13_311*C13-ROcp13_912*S13;
ROcp13_713 = ROcp13_712*C13+C11*S13;
ROcp13_813 = ROcp13_211*S13+ROcp13_812*C13;
ROcp13_913 = ROcp13_311*S13+ROcp13_912*C13;
POcp13_32 = q[1]+dpt[3][6];
OMcp13_23 = -qd[11]*S10;
OMcp13_33 = qd[11]*C10;
OPcp13_23 = -qdd[11]*S10-qd[10]*qd[11]*C10;
OPcp13_33 = qdd[11]*C10-qd[10]*qd[11]*S10;
RLcp13_14 = -dpt[2][12]*S11;
RLcp13_24 = ROcp13_511*dpt[2][12];
RLcp13_34 = ROcp13_611*dpt[2][12];
POcp13_14 = RLcp13_14+dpt[1][6];
POcp13_24 = RLcp13_24+dpt[2][6];
POcp13_34 = POcp13_32+RLcp13_34;
JTcp13_14_3 = -RLcp13_24*C10-RLcp13_34*S10;
JTcp13_24_3 = RLcp13_14*C10;
JTcp13_34_3 = RLcp13_14*S10;
OMcp13_14 = qd[10]+qd[12]*C11;
OMcp13_24 = OMcp13_23+ROcp13_211*qd[12];
OMcp13_34 = OMcp13_33+ROcp13_311*qd[12];
ORcp13_14 = OMcp13_23*RLcp13_34-OMcp13_33*RLcp13_24;
ORcp13_24 = OMcp13_33*RLcp13_14-RLcp13_34*qd[10];
ORcp13_34 = -OMcp13_23*RLcp13_14+RLcp13_24*qd[10];
VIcp13_34 = ORcp13_34+qd[1];
OPcp13_14 = qdd[10]+qdd[12]*C11+qd[12]*(OMcp13_23*ROcp13_311-OMcp13_33*ROcp13_211);
OPcp13_24 = OPcp13_23+ROcp13_211*qdd[12]+qd[12]*(OMcp13_33*C11-ROcp13_311*qd[10]);
OPcp13_34 = OPcp13_33+ROcp13_311*qdd[12]+qd[12]*(-OMcp13_23*C11+ROcp13_211*qd[10]);
ACcp13_14 = OMcp13_23*ORcp13_34-OMcp13_33*ORcp13_24+OPcp13_23*RLcp13_34-OPcp13_33*RLcp13_24;
ACcp13_24 = OMcp13_33*ORcp13_14+OPcp13_33*RLcp13_14-ORcp13_34*qd[10]-RLcp13_34*qdd[10];
ACcp13_34 = qdd[1]-OMcp13_23*ORcp13_14-OPcp13_23*RLcp13_14+ORcp13_24*qd[10]+RLcp13_24*qdd[10];
OMcp13_15 = OMcp13_14+ROcp13_412*qd[13];
OMcp13_25 = OMcp13_24+ROcp13_512*qd[13];
OMcp13_35 = OMcp13_34+ROcp13_612*qd[13];
OPcp13_15 = OPcp13_14+ROcp13_412*qdd[13]+qd[13]*(OMcp13_24*ROcp13_612-OMcp13_34*ROcp13_512);
OPcp13_25 = OPcp13_24+ROcp13_512*qdd[13]+qd[13]*(-OMcp13_14*ROcp13_612+OMcp13_34*ROcp13_412);
OPcp13_35 = OPcp13_34+ROcp13_612*qdd[13]+qd[13]*(OMcp13_14*ROcp13_512-OMcp13_24*ROcp13_412);
sens->P[1] = POcp13_14;
sens->P[2] = POcp13_24;
sens->P[3] = POcp13_34;
sens->R[1][1] = ROcp13_113;
sens->R[1][2] = ROcp13_213;
sens->R[1][3] = ROcp13_313;
sens->R[2][1] = ROcp13_412;
sens->R[2][2] = ROcp13_512;
sens->R[2][3] = ROcp13_612;
sens->R[3][1] = ROcp13_713;
sens->R[3][2] = ROcp13_813;
sens->R[3][3] = ROcp13_913;
sens->V[1] = ORcp13_14;
sens->V[2] = ORcp13_24;
sens->V[3] = VIcp13_34;
sens->OM[1] = OMcp13_15;
sens->OM[2] = OMcp13_25;
sens->OM[3] = OMcp13_35;
sens->J[1][11] = JTcp13_14_3;
sens->J[2][10] = -RLcp13_34;
sens->J[2][11] = JTcp13_24_3;
sens->J[3][1] = (1.0);
sens->J[3][10] = RLcp13_24;
sens->J[3][11] = JTcp13_34_3;
sens->J[4][10] = (1.0);
sens->J[4][12] = C11;
sens->J[4][13] = ROcp13_412;
sens->J[5][11] = -S10;
sens->J[5][12] = ROcp13_211;
sens->J[5][13] = ROcp13_512;
sens->J[6][11] = C10;
sens->J[6][12] = ROcp13_311;
sens->J[6][13] = ROcp13_612;
sens->A[1] = ACcp13_14;
sens->A[2] = ACcp13_24;
sens->A[3] = ACcp13_34;
sens->OMP[1] = OPcp13_15;
sens->OMP[2] = OPcp13_25;
sens->OMP[3] = OPcp13_35;

break;

case 14:

ROcp14_211 = C10*S11;
ROcp14_311 = S10*S11;
ROcp14_511 = C10*C11;
ROcp14_611 = S10*C11;
ROcp14_412 = -S11*C12;
ROcp14_512 = ROcp14_511*C12-S10*S12;
ROcp14_612 = ROcp14_611*C12+C10*S12;
ROcp14_712 = S11*S12;
ROcp14_812 = -ROcp14_511*S12-S10*C12;
ROcp14_912 = -ROcp14_611*S12+C10*C12;
ROcp14_113 = -ROcp14_712*S13+C11*C13;
ROcp14_213 = ROcp14_211*C13-ROcp14_812*S13;
ROcp14_313 = ROcp14_311*C13-ROcp14_912*S13;
ROcp14_713 = ROcp14_712*C13+C11*S13;
ROcp14_813 = ROcp14_211*S13+ROcp14_812*C13;
ROcp14_913 = ROcp14_311*S13+ROcp14_912*C13;
ROcp14_114 = ROcp14_113*C14+ROcp14_412*S14;
ROcp14_214 = ROcp14_213*C14+ROcp14_512*S14;
ROcp14_314 = ROcp14_313*C14+ROcp14_612*S14;
ROcp14_414 = -ROcp14_113*S14+ROcp14_412*C14;
ROcp14_514 = -ROcp14_213*S14+ROcp14_512*C14;
ROcp14_614 = -ROcp14_313*S14+ROcp14_612*C14;
POcp14_32 = q[1]+dpt[3][6];
OMcp14_23 = -qd[11]*S10;
OMcp14_33 = qd[11]*C10;
OPcp14_23 = -qdd[11]*S10-qd[10]*qd[11]*C10;
OPcp14_33 = qdd[11]*C10-qd[10]*qd[11]*S10;
RLcp14_14 = -dpt[2][12]*S11;
RLcp14_24 = ROcp14_511*dpt[2][12];
RLcp14_34 = ROcp14_611*dpt[2][12];
POcp14_14 = RLcp14_14+dpt[1][6];
POcp14_24 = RLcp14_24+dpt[2][6];
POcp14_34 = POcp14_32+RLcp14_34;
JTcp14_14_3 = -RLcp14_24*C10-RLcp14_34*S10;
JTcp14_24_3 = RLcp14_14*C10;
JTcp14_34_3 = RLcp14_14*S10;
OMcp14_14 = qd[10]+qd[12]*C11;
OMcp14_24 = OMcp14_23+ROcp14_211*qd[12];
OMcp14_34 = OMcp14_33+ROcp14_311*qd[12];
ORcp14_14 = OMcp14_23*RLcp14_34-OMcp14_33*RLcp14_24;
ORcp14_24 = OMcp14_33*RLcp14_14-RLcp14_34*qd[10];
ORcp14_34 = -OMcp14_23*RLcp14_14+RLcp14_24*qd[10];
VIcp14_34 = ORcp14_34+qd[1];
OPcp14_14 = qdd[10]+qdd[12]*C11+qd[12]*(OMcp14_23*ROcp14_311-OMcp14_33*ROcp14_211);
OPcp14_24 = OPcp14_23+ROcp14_211*qdd[12]+qd[12]*(OMcp14_33*C11-ROcp14_311*qd[10]);
OPcp14_34 = OPcp14_33+ROcp14_311*qdd[12]+qd[12]*(-OMcp14_23*C11+ROcp14_211*qd[10]);
ACcp14_14 = OMcp14_23*ORcp14_34-OMcp14_33*ORcp14_24+OPcp14_23*RLcp14_34-OPcp14_33*RLcp14_24;
ACcp14_24 = OMcp14_33*ORcp14_14+OPcp14_33*RLcp14_14-ORcp14_34*qd[10]-RLcp14_34*qdd[10];
ACcp14_34 = qdd[1]-OMcp14_23*ORcp14_14-OPcp14_23*RLcp14_14+ORcp14_24*qd[10]+RLcp14_24*qdd[10];
OMcp14_15 = OMcp14_14+ROcp14_412*qd[13];
OMcp14_25 = OMcp14_24+ROcp14_512*qd[13];
OMcp14_35 = OMcp14_34+ROcp14_612*qd[13];
OPcp14_15 = OPcp14_14+ROcp14_412*qdd[13]+qd[13]*(OMcp14_24*ROcp14_612-OMcp14_34*ROcp14_512);
OPcp14_25 = OPcp14_24+ROcp14_512*qdd[13]+qd[13]*(-OMcp14_14*ROcp14_612+OMcp14_34*ROcp14_412);
OPcp14_35 = OPcp14_34+ROcp14_612*qdd[13]+qd[13]*(OMcp14_14*ROcp14_512-OMcp14_24*ROcp14_412);
OMcp14_16 = OMcp14_15+ROcp14_713*qd[14];
OMcp14_26 = OMcp14_25+ROcp14_813*qd[14];
OMcp14_36 = OMcp14_35+ROcp14_913*qd[14];
OPcp14_16 = OPcp14_15+ROcp14_713*qdd[14]+qd[14]*(OMcp14_25*ROcp14_913-OMcp14_35*ROcp14_813);
OPcp14_26 = OPcp14_25+ROcp14_813*qdd[14]+qd[14]*(-OMcp14_15*ROcp14_913+OMcp14_35*ROcp14_713);
OPcp14_36 = OPcp14_35+ROcp14_913*qdd[14]+qd[14]*(OMcp14_15*ROcp14_813-OMcp14_25*ROcp14_713);
sens->P[1] = POcp14_14;
sens->P[2] = POcp14_24;
sens->P[3] = POcp14_34;
sens->R[1][1] = ROcp14_114;
sens->R[1][2] = ROcp14_214;
sens->R[1][3] = ROcp14_314;
sens->R[2][1] = ROcp14_414;
sens->R[2][2] = ROcp14_514;
sens->R[2][3] = ROcp14_614;
sens->R[3][1] = ROcp14_713;
sens->R[3][2] = ROcp14_813;
sens->R[3][3] = ROcp14_913;
sens->V[1] = ORcp14_14;
sens->V[2] = ORcp14_24;
sens->V[3] = VIcp14_34;
sens->OM[1] = OMcp14_16;
sens->OM[2] = OMcp14_26;
sens->OM[3] = OMcp14_36;
sens->J[1][11] = JTcp14_14_3;
sens->J[2][10] = -RLcp14_34;
sens->J[2][11] = JTcp14_24_3;
sens->J[3][1] = (1.0);
sens->J[3][10] = RLcp14_24;
sens->J[3][11] = JTcp14_34_3;
sens->J[4][10] = (1.0);
sens->J[4][12] = C11;
sens->J[4][13] = ROcp14_412;
sens->J[4][14] = ROcp14_713;
sens->J[5][11] = -S10;
sens->J[5][12] = ROcp14_211;
sens->J[5][13] = ROcp14_512;
sens->J[5][14] = ROcp14_813;
sens->J[6][11] = C10;
sens->J[6][12] = ROcp14_311;
sens->J[6][13] = ROcp14_612;
sens->J[6][14] = ROcp14_913;
sens->A[1] = ACcp14_14;
sens->A[2] = ACcp14_24;
sens->A[3] = ACcp14_34;
sens->OMP[1] = OPcp14_16;
sens->OMP[2] = OPcp14_26;
sens->OMP[3] = OPcp14_36;

break;

case 15:

ROcp15_211 = C10*S11;
ROcp15_311 = S10*S11;
ROcp15_511 = C10*C11;
ROcp15_611 = S10*C11;
ROcp15_412 = -S11*C12;
ROcp15_512 = ROcp15_511*C12-S10*S12;
ROcp15_612 = ROcp15_611*C12+C10*S12;
ROcp15_712 = S11*S12;
ROcp15_812 = -ROcp15_511*S12-S10*C12;
ROcp15_912 = -ROcp15_611*S12+C10*C12;
ROcp15_113 = -ROcp15_712*S13+C11*C13;
ROcp15_213 = ROcp15_211*C13-ROcp15_812*S13;
ROcp15_313 = ROcp15_311*C13-ROcp15_912*S13;
ROcp15_713 = ROcp15_712*C13+C11*S13;
ROcp15_813 = ROcp15_211*S13+ROcp15_812*C13;
ROcp15_913 = ROcp15_311*S13+ROcp15_912*C13;
ROcp15_114 = ROcp15_113*C14+ROcp15_412*S14;
ROcp15_214 = ROcp15_213*C14+ROcp15_512*S14;
ROcp15_314 = ROcp15_313*C14+ROcp15_612*S14;
ROcp15_414 = -ROcp15_113*S14+ROcp15_412*C14;
ROcp15_514 = -ROcp15_213*S14+ROcp15_512*C14;
ROcp15_614 = -ROcp15_313*S14+ROcp15_612*C14;
ROcp15_115 = ROcp15_114*C15-ROcp15_713*S15;
ROcp15_215 = ROcp15_214*C15-ROcp15_813*S15;
ROcp15_315 = ROcp15_314*C15-ROcp15_913*S15;
ROcp15_715 = ROcp15_114*S15+ROcp15_713*C15;
ROcp15_815 = ROcp15_214*S15+ROcp15_813*C15;
ROcp15_915 = ROcp15_314*S15+ROcp15_913*C15;
POcp15_32 = q[1]+dpt[3][6];
OMcp15_23 = -qd[11]*S10;
OMcp15_33 = qd[11]*C10;
OPcp15_23 = -qdd[11]*S10-qd[10]*qd[11]*C10;
OPcp15_33 = qdd[11]*C10-qd[10]*qd[11]*S10;
RLcp15_14 = -dpt[2][12]*S11;
RLcp15_24 = ROcp15_511*dpt[2][12];
RLcp15_34 = ROcp15_611*dpt[2][12];
POcp15_14 = RLcp15_14+dpt[1][6];
POcp15_24 = RLcp15_24+dpt[2][6];
POcp15_34 = POcp15_32+RLcp15_34;
JTcp15_14_3 = -RLcp15_24*C10-RLcp15_34*S10;
JTcp15_24_3 = RLcp15_14*C10;
JTcp15_34_3 = RLcp15_14*S10;
OMcp15_14 = qd[10]+qd[12]*C11;
OMcp15_24 = OMcp15_23+ROcp15_211*qd[12];
OMcp15_34 = OMcp15_33+ROcp15_311*qd[12];
ORcp15_14 = OMcp15_23*RLcp15_34-OMcp15_33*RLcp15_24;
ORcp15_24 = OMcp15_33*RLcp15_14-RLcp15_34*qd[10];
ORcp15_34 = -OMcp15_23*RLcp15_14+RLcp15_24*qd[10];
VIcp15_34 = ORcp15_34+qd[1];
OPcp15_14 = qdd[10]+qdd[12]*C11+qd[12]*(OMcp15_23*ROcp15_311-OMcp15_33*ROcp15_211);
OPcp15_24 = OPcp15_23+ROcp15_211*qdd[12]+qd[12]*(OMcp15_33*C11-ROcp15_311*qd[10]);
OPcp15_34 = OPcp15_33+ROcp15_311*qdd[12]+qd[12]*(-OMcp15_23*C11+ROcp15_211*qd[10]);
ACcp15_14 = OMcp15_23*ORcp15_34-OMcp15_33*ORcp15_24+OPcp15_23*RLcp15_34-OPcp15_33*RLcp15_24;
ACcp15_24 = OMcp15_33*ORcp15_14+OPcp15_33*RLcp15_14-ORcp15_34*qd[10]-RLcp15_34*qdd[10];
ACcp15_34 = qdd[1]-OMcp15_23*ORcp15_14-OPcp15_23*RLcp15_14+ORcp15_24*qd[10]+RLcp15_24*qdd[10];
OMcp15_15 = OMcp15_14+ROcp15_412*qd[13];
OMcp15_25 = OMcp15_24+ROcp15_512*qd[13];
OMcp15_35 = OMcp15_34+ROcp15_612*qd[13];
OPcp15_15 = OPcp15_14+ROcp15_412*qdd[13]+qd[13]*(OMcp15_24*ROcp15_612-OMcp15_34*ROcp15_512);
OPcp15_25 = OPcp15_24+ROcp15_512*qdd[13]+qd[13]*(-OMcp15_14*ROcp15_612+OMcp15_34*ROcp15_412);
OPcp15_35 = OPcp15_34+ROcp15_612*qdd[13]+qd[13]*(OMcp15_14*ROcp15_512-OMcp15_24*ROcp15_412);
OMcp15_16 = OMcp15_15+ROcp15_713*qd[14];
OMcp15_26 = OMcp15_25+ROcp15_813*qd[14];
OMcp15_36 = OMcp15_35+ROcp15_913*qd[14];
OPcp15_16 = OPcp15_15+ROcp15_713*qdd[14]+qd[14]*(OMcp15_25*ROcp15_913-OMcp15_35*ROcp15_813);
OPcp15_26 = OPcp15_25+ROcp15_813*qdd[14]+qd[14]*(-OMcp15_15*ROcp15_913+OMcp15_35*ROcp15_713);
OPcp15_36 = OPcp15_35+ROcp15_913*qdd[14]+qd[14]*(OMcp15_15*ROcp15_813-OMcp15_25*ROcp15_713);
RLcp15_17 = ROcp15_114*dpt[1][14]+ROcp15_414*dpt[2][14]+ROcp15_713*dpt[3][14];
RLcp15_27 = ROcp15_214*dpt[1][14]+ROcp15_514*dpt[2][14]+ROcp15_813*dpt[3][14];
RLcp15_37 = ROcp15_314*dpt[1][14]+ROcp15_614*dpt[2][14]+ROcp15_913*dpt[3][14];
POcp15_17 = POcp15_14+RLcp15_17;
POcp15_27 = POcp15_24+RLcp15_27;
POcp15_37 = POcp15_34+RLcp15_37;
JTcp15_27_2 = -RLcp15_34-RLcp15_37;
JTcp15_37_2 = RLcp15_24+RLcp15_27;
JTcp15_17_3 = JTcp15_14_3-RLcp15_27*C10-RLcp15_37*S10;
JTcp15_27_3 = JTcp15_24_3+RLcp15_17*C10;
JTcp15_37_3 = JTcp15_34_3+RLcp15_17*S10;
JTcp15_17_4 = -RLcp15_27*ROcp15_311+RLcp15_37*ROcp15_211;
JTcp15_27_4 = RLcp15_17*ROcp15_311-RLcp15_37*C11;
JTcp15_37_4 = -RLcp15_17*ROcp15_211+RLcp15_27*C11;
JTcp15_17_5 = -RLcp15_27*ROcp15_612+RLcp15_37*ROcp15_512;
JTcp15_27_5 = RLcp15_17*ROcp15_612-RLcp15_37*ROcp15_412;
JTcp15_37_5 = -RLcp15_17*ROcp15_512+RLcp15_27*ROcp15_412;
JTcp15_17_6 = -RLcp15_27*ROcp15_913+RLcp15_37*ROcp15_813;
JTcp15_27_6 = RLcp15_17*ROcp15_913-RLcp15_37*ROcp15_713;
JTcp15_37_6 = -RLcp15_17*ROcp15_813+RLcp15_27*ROcp15_713;
OMcp15_17 = OMcp15_16+ROcp15_414*qd[15];
OMcp15_27 = OMcp15_26+ROcp15_514*qd[15];
OMcp15_37 = OMcp15_36+ROcp15_614*qd[15];
ORcp15_17 = OMcp15_26*RLcp15_37-OMcp15_36*RLcp15_27;
ORcp15_27 = -OMcp15_16*RLcp15_37+OMcp15_36*RLcp15_17;
ORcp15_37 = OMcp15_16*RLcp15_27-OMcp15_26*RLcp15_17;
VIcp15_17 = ORcp15_14+ORcp15_17;
VIcp15_27 = ORcp15_24+ORcp15_27;
VIcp15_37 = ORcp15_37+VIcp15_34;
OPcp15_17 = OPcp15_16+ROcp15_414*qdd[15]+qd[15]*(OMcp15_26*ROcp15_614-OMcp15_36*ROcp15_514);
OPcp15_27 = OPcp15_26+ROcp15_514*qdd[15]+qd[15]*(-OMcp15_16*ROcp15_614+OMcp15_36*ROcp15_414);
OPcp15_37 = OPcp15_36+ROcp15_614*qdd[15]+qd[15]*(OMcp15_16*ROcp15_514-OMcp15_26*ROcp15_414);
ACcp15_17 = ACcp15_14+OMcp15_26*ORcp15_37-OMcp15_36*ORcp15_27+OPcp15_26*RLcp15_37-OPcp15_36*RLcp15_27;
ACcp15_27 = ACcp15_24-OMcp15_16*ORcp15_37+OMcp15_36*ORcp15_17-OPcp15_16*RLcp15_37+OPcp15_36*RLcp15_17;
ACcp15_37 = ACcp15_34+OMcp15_16*ORcp15_27-OMcp15_26*ORcp15_17+OPcp15_16*RLcp15_27-OPcp15_26*RLcp15_17;
sens->P[1] = POcp15_17;
sens->P[2] = POcp15_27;
sens->P[3] = POcp15_37;
sens->R[1][1] = ROcp15_115;
sens->R[1][2] = ROcp15_215;
sens->R[1][3] = ROcp15_315;
sens->R[2][1] = ROcp15_414;
sens->R[2][2] = ROcp15_514;
sens->R[2][3] = ROcp15_614;
sens->R[3][1] = ROcp15_715;
sens->R[3][2] = ROcp15_815;
sens->R[3][3] = ROcp15_915;
sens->V[1] = VIcp15_17;
sens->V[2] = VIcp15_27;
sens->V[3] = VIcp15_37;
sens->OM[1] = OMcp15_17;
sens->OM[2] = OMcp15_27;
sens->OM[3] = OMcp15_37;
sens->J[1][11] = JTcp15_17_3;
sens->J[1][12] = JTcp15_17_4;
sens->J[1][13] = JTcp15_17_5;
sens->J[1][14] = JTcp15_17_6;
sens->J[2][10] = JTcp15_27_2;
sens->J[2][11] = JTcp15_27_3;
sens->J[2][12] = JTcp15_27_4;
sens->J[2][13] = JTcp15_27_5;
sens->J[2][14] = JTcp15_27_6;
sens->J[3][1] = (1.0);
sens->J[3][10] = JTcp15_37_2;
sens->J[3][11] = JTcp15_37_3;
sens->J[3][12] = JTcp15_37_4;
sens->J[3][13] = JTcp15_37_5;
sens->J[3][14] = JTcp15_37_6;
sens->J[4][10] = (1.0);
sens->J[4][12] = C11;
sens->J[4][13] = ROcp15_412;
sens->J[4][14] = ROcp15_713;
sens->J[4][15] = ROcp15_414;
sens->J[5][11] = -S10;
sens->J[5][12] = ROcp15_211;
sens->J[5][13] = ROcp15_512;
sens->J[5][14] = ROcp15_813;
sens->J[5][15] = ROcp15_514;
sens->J[6][11] = C10;
sens->J[6][12] = ROcp15_311;
sens->J[6][13] = ROcp15_612;
sens->J[6][14] = ROcp15_913;
sens->J[6][15] = ROcp15_614;
sens->A[1] = ACcp15_17;
sens->A[2] = ACcp15_27;
sens->A[3] = ACcp15_37;
sens->OMP[1] = OPcp15_17;
sens->OMP[2] = OPcp15_27;
sens->OMP[3] = OPcp15_37;

break;

case 16:

sens->P[1] = 0;
sens->P[2] = dpt[2][1];
sens->P[3] = q[16];
sens->R[1][1] = (1.0);
sens->R[2][2] = (1.0);
sens->R[3][3] = (1.0);
sens->V[1] = 0;
sens->V[2] = 0;
sens->V[3] = qd[16];
sens->OM[1] = 0;
sens->OM[2] = 0;
sens->OM[3] = 0;
sens->J[3][16] = (1.0);
sens->A[1] = 0;
sens->A[2] = 0;
sens->A[3] = qdd[16];
sens->OMP[1] = 0;
sens->OMP[2] = 0;
sens->OMP[3] = 0;

break;

default:

break;

}


// Number of continuation lines = 0

}
